#include "c4d_general.h"
#include "c4d_shader.h"
#include "c4d_file.h"
#include "c4d_basecontainer.h"
#include "c4d_gui.h"

Parser *Parser::Alloc(void)
{
	return C4DOS.Pr->Alloc();
}

void Parser::Free(Parser *&pr)
{
	C4DOS.Pr->Free(pr);
	pr=NULL;
}

Bool Parser::AddVar(const String &str, Real *value)
{
	return C4DOS.Pr->AddVar(this,&str,value);
}

Bool Parser::Eval(const String &str, LONG *error, Real *res, LONG unit, LONG angletype, LONG basis)
{
	return C4DOS.Pr->Eval(this,&str,error,res,unit,angletype,basis);
}

void GeShowMouse(LONG v)
{
	C4DOS.Ge->ShowMouse(v);
}

void GeGetSysTime(LONG *year, LONG *month, LONG *day, LONG *hour, LONG *minute, LONG *second)
{
	C4DOS.Ge->GetSysTime(year,month,day,hour,minute,second);
}

String GeGetLineEnd(void)
{
	String str;
	C4DOS.Ge->GetLineEnd(&str);
	return str;
}

LONG GeGetDefaultFPS(void)
{
	return C4DOS.Ge->GetDefaultFPS();
}

LONG GeOutString(const String &str, LONG flags)
{
	return C4DOS.Ge->OutString(&str,flags);
}

LONG GeGetCurrentOS(void)
{
	return C4DOS.Ge->GetCurrentOS();
}

LONG GeGetByteOrder(void)
{
	return C4DOS.Ge->GetByteOrder();
}

void GeGetGray(LONG *r, LONG *g, LONG *b)
{
	C4DOS.Ge->GetGray(r,g,b);
}

Bool GeChooseColor(Vector *col)
{
	return C4DOS.Ge->ChooseColor(col);
}

Bool GeOpenHTML(const String &webaddress)
{
	return C4DOS.Ge->OpenHTML(webaddress);
}

Bool GeChooseFont(BaseContainer *bc)
{
	return C4DOS.Ge->ChooseFont(bc);
}
																  
void GeGetSerialInfo(LONG type, SerialInfo *si)
{
	C4DOS.Ge->GetSerialInfo(type,&si->nr,&si->name,&si->organization,&si->street,&si->city,&si->country);
}

LONG GeGetVersionType(void)
{
	return C4DOS.Ge->GetVersionType();
}

Bool GeRegisterPlugin(LONG type, LONG id, const String &str, void *data, LONG datasize)
{
	return C4DOS.Ge->RegisterPlugin(API_VERSION,type,id,&str,data,datasize);
}

void GePrint(const String &str)
{
	C4DOS.Ge->Print(&str);
}

void SetMousePointer(LONG l)
{
	C4DOS.Ge->SetMousePointer(l);
}

Bool ShowBitmap(const Filename &fn)
{
	return C4DOS.Ge->ShowBitmap1(&fn);
}

Bool ShowBitmap(BaseBitmap *bm)
{
	return C4DOS.Ge->ShowBitmap2(bm);
}

void StopAllThreads(void)
{
	C4DOS.Ge->StopAllThreads();
}

void StatusClear(void)
{
	C4DOS.Ge->StatusClear();
}

void StatusSetSpin(void)
{
	C4DOS.Ge->StatusSetSpin();
}

void StatusSetBar(LONG p)
{
	C4DOS.Ge->StatusSetBar(p);
}

void StatusSetText(const String &str)
{
	C4DOS.Ge->StatusSetText(&str);
}

void SpecialEventAdd(LONG messageid, ULONG p1, ULONG p2)
{
	C4DOS.Ge->SpecialEventAdd(messageid,p1,p2);
}

void EventAdd(LONG flags)
{
	C4DOS.Ge->EventAdd(flags);
}

Bool GeSyncMessage(LONG messageid, LONG destid,ULONG p1, ULONG p2)
{
	return C4DOS.Ge->SyncMessage(messageid,destid,p1,p2);
}

Bool DrawViews(LONG flags)
{
	return C4DOS.Ge->DrawViews(flags);
}

Bool SendModelingCommand(LONG command, ModelingCommandData &data)
{
	return C4DOS.Ge->SendModelingCommand(command,data);
}

Filename GetGlobalTexturePath(LONG i)
{
	Filename fn;
	C4DOS.Ge->GetGlobalTexturePath(i,&fn);
	return fn;
}

void SetGlobalTexturePath(LONG i, const Filename &fn)
{
	C4DOS.Ge->SetGlobalTexturePath(i,&fn);
}

Bool IsInSearchPath(const Filename &texfilename, const Filename &docpath)
{
	return C4DOS.Ge->IsInSearchPath(texfilename,docpath);
}

Bool GenerateTexturePath(const Filename &docpath, const Filename &srcname, const Filename &suggestedfolder, Filename *dstname)
{
	return C4DOS.Ge->GenerateTexturePath(docpath,srcname,suggestedfolder,dstname);
}

void FlushTexture(const Filename &docpath, const String &name)
{
	C4DOS.Ge->FlushTexture(&docpath,&name);
}

void FlushUnusedTextures(void)
{
	C4DOS.Ge->FlushUnusedTextures();
}

BaseContainer *GetWorldPluginData(LONG id)
{
	return C4DOS.Ge->GetWorldPluginData(id);
}

Bool SetWorldPluginData(LONG id, const BaseContainer &bc, Bool add)
{
	return C4DOS.Ge->SetWorldPluginData(id,&bc,add);
}

BaseContainer GetWorldContainer(void)
{
	BaseContainer bc;
	C4DOS.Ge->GetWorldContainer(&bc);
	return bc;
}

BaseContainer *GetWorldContainerInstance(void)
{
	return C4DOS.Ge->GetWorldContainerInstance();
}

void SetWorldContainer(const BaseContainer &bc)
{
	C4DOS.Ge->SetWorldContainer(&bc);
}

Vector GetWorldColor(LONG i)
{
	return C4DOS.Ge->GetColor(i);
}

void ErrorStringDialog(LONG type, Real x, Real y, LONG is)
{
	C4DOS.Ge->ErrorStringDialog(type,x,y,is);
}

Bool ReadPluginInfo(LONG pluginid, void *buffer, LONG size)
{
	return C4DOS.Ge->ReadPluginInfo(pluginid,(CHAR*)buffer,size);
}

Bool WritePluginInfo(LONG pluginid, void *buffer, LONG size)
{
	return C4DOS.Ge->WritePluginInfo(pluginid,(CHAR*)buffer,size);
}

Bool GeGetMovieInfo(const Filename &fn, LONG *frames, LONG *fps)
{
	return C4DOS.Ge->GetMovieInfo(&fn,frames,fps);
}

Bool GeRegistryAdd(LONG sub_id, LONG main_id, void *data)
{
	return C4DOS.Ge->RegistryAdd(sub_id,main_id,data);
}

Bool GeRegistryRemove(LONG sub_id, LONG main_id)
{
	return C4DOS.Ge->RegistryRemove(sub_id,main_id);
}

Registry *GeRegistryFind(LONG sub_id, LONG main_id)
{
	return C4DOS.Ge->RegistryFind(sub_id,main_id);
}

Registry *GeRegistryFindLast(LONG main_id)
{
	return C4DOS.Ge->RegistryFindLast(main_id);
}

Registry *GeRegistryFindFirst(LONG main_id)
{
	return C4DOS.Ge->RegistryFindFirst(main_id);
}

Registry *GeRegistryFindPrev(Registry *last)
{
	return C4DOS.Ge->RegistryFindPrev(last);
}

Registry *GeRegistryFindNext(Registry *last)
{
	return C4DOS.Ge->RegistryFindNext(last);
}

Bool GeRegistryGetAutoID(LONG *id)
{
	return C4DOS.Ge->RegistryGetAutoID(id);
}

LONG Registry::GetMainID(void)
{
	LONG main_id,sub_id;
	void *data;
	if (!C4DOS.Ge->RegistryGetData(this,&main_id,&sub_id,&data)) return 0;
	return main_id;
}

LONG Registry::GetSubID(void)
{
	LONG main_id,sub_id;
	void *data;
	if (!C4DOS.Ge->RegistryGetData(this,&main_id,&sub_id,&data)) return 0;
	return sub_id;
}

void *Registry::GetData(void)
{
	LONG main_id,sub_id;
	void *data;
	if (!C4DOS.Ge->RegistryGetData(this,&main_id,&sub_id,&data)) return NULL;
	return data;
}

Bool RenameDialog(String *str)
{
	return C4DOS.Ge->RenameDialog(str);
}

Bool LassoSelection::Start(GeDialog &dlg, LONG mode, LONG start_x, LONG start_y, LONG start_button, LONG sx1, LONG sy1, LONG sx2, LONG sy2)
{
	return C4DOS.Cd->LSStart(this,(CBaseFrame*)dlg.Get(),mode,start_x,start_y,start_button,sx1,sy1,sx2,sy2);
}

Bool LassoSelection::Start(GeUserArea &ua, LONG mode, LONG start_x, LONG start_y, LONG start_button, LONG sx1, LONG sy1, LONG sx2, LONG sy2)
{
	return C4DOS.Cd->LSStart(this,(CBaseFrame*)ua.Get(),mode,start_x,start_y,start_button,sx1,sy1,sx2,sy2);
}

Bool LassoSelection::CheckSingleClick()
{
	return C4DOS.Cd->LSCheckSingleClick(this);
}

Bool LassoSelection::Test(LONG x, LONG y)
{
	return C4DOS.Cd->LSTest(this,x,y);
}

Bool LassoSelection::TestPolygon(const Vector &pa, const Vector &pb, const Vector &pc, const Vector &pd)
{
	return C4DOS.Cd->LSTestPolygon(this,pa,pb,pc,pd);
}

LONG LassoSelection::GetMode()
{
	return C4DOS.Cd->LSGetMode(this);
}

LassoSelection *LassoSelection::Alloc()
{
	return C4DOS.Cd->LSAlloc();
}

void LassoSelection::Free(LassoSelection *&ls)
{
	C4DOS.Cd->LSFree(ls);
	ls=NULL;
}

void FindInManager(BaseList2D *bl)
{
	C4DOS.Ge->FindInManager(bl);
}

void GeSleep(LONG milliseconds)
{
	C4DOS.Ge->GeSleep(milliseconds);
}

void GeBoom(void)
{
	C4DOS.Ge->Boom();
}

GeData SendCoreMessage(LONG coreid, const BaseContainer &msg, LONG eventid)
{
	return C4DOS.Ge->SendCoreMessage(coreid,msg,eventid);
}

BaseContainer GlGetFeatures()
{
	GeData dat = SendCoreMessage(COREMSG_CINEMA,BaseContainer(COREMSG_CINEMA_GETOPENGLFEATURES),0);
	if (!dat.GetContainer()) return BaseContainer();
	return *dat.GetContainer();
}

Bool GePluginMessage(LONG id, void *data)
{
	return C4DOS.Ge->PluginMessage(id,data);
}

Bool CheckIsRunning(LONG type)
{
	return C4DOS.Ge->CheckIsRunning(type);
}

void _GeDebugBreak(LONG line, const CHAR *file)
{
	C4DOS.Ge->GeDebugBreak(line,file);
}

#include <stdarg.h>
#include <stdio.h>
#include <string.h>

void GeDebugOut(const CHAR* s, ...)
{
	va_list arp;
	va_start(arp, s);

	CHAR t[2048];

	vsprintf(t, s, arp);
	C4DOS.Ge->GeDebugOut("%s",t);

	va_end(arp);

}
